% Skript bodeSysDiskret.m
%
% Aufruf:  bodeSysDiskret
%
% Beispiel fr Bode-Diagramm eimnes diskreten LTI-Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018

% bertragungsfunktion definieren
a = 1/2;
z = tf('z',1);% zeigt zeitdiskretes System an
H = z/(z-a);  %stabiles LTI-System, da |a|<1

% Frequenzvektor in rad im Nyquist-Intervall
% [0,pi] definieren
Omega = (0:0.01:pi);

% Bode-Diagramm berechnen
[Ampg,phasg] = bode(H,Omega);

% Plot des Bode-Diagramms ("von Hand"
% Ohne die Rckgabewerte wird der Plot
% automatisch ausgefhrt ist aber nicht so
% flexibel)

% Vektoren erzeugen  
Ampg = abs( Ampg(:) );
phasg =  phasg(:) ;          % bode liefert Phasengang
                             % in GRAD!!!!
figure
subplot(211)
semilogx(Omega, 20*log10(Ampg), 'b', 'Linewidth',2);
grid
axis([Omega(1), Omega(end), 1.1*min(20*log10(Ampg)),1.1*max(20*log10(Ampg))])
xlabel('normierte Frequenz/rad')
ylabel('dB')

subplot(212)
semilogx(Omega, phasg, 'k', 'Linewidth',2);
grid
axis([Omega(1), Omega(end), 1.1*min(phasg),1.1*max(phasg)])
xlabel('normierte Frequenz/rad')
ylabel('grad')