% Skript bodeSysDiskret2.m
%
% Aufruf:  bodeSysDiskret2
%
% Beispiel fr Bode-Diagramm eines diskreten LTI-Systems
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 19.04.2018/19.05.2018

% bertragungsfunktion definieren
B = [1 0];     % Zhlerkoeffizienten
A = [1 -1/2];  % Nennerkoeffizienten

% Frequenzvektor in rad im Nyquist-Intervall
Om = (0:0.01:pi);    % geht in diesem Fall

% Bode-Diagramm berechnen
[HOmega,Nfrequenz] = freqz(B,A,Om);
Ampg = abs(HOmega);
phasg = angle(HOmega)*180/pi;  % ANGLE berechnet Phasenwinkel
                               % in RAD!!!

subplot(211)
semilogx(Om, 20*log10(Ampg), 'b', 'Linewidth',2);
grid
axis([Om(1), Om(end), 1.1*min(20*log10(Ampg)),1.1*max(20*log10(Ampg))])
xlabel('normierte Frequenz/rad')
ylabel('dB')

subplot(212)
semilogx(Om, phasg, 'k', 'Linewidth',2);
grid
axis([Om(1), Om(end), 1.1*min(phasg),1.1*max(phasg)])
xlabel('normierte Frequenz/rad')
ylabel('Grad')