% Script bsp2UebFunkt_tf
%
% Aufruf: bsp2UebFunkt_tf
%
% Zusammenfassung der Beispiele fr die Berechnung
% bertragungsfunktion digitaler LTI-Systeme mit 
% Hilfe der tf-Funktionen der Control Systems Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.11.2014/19.05.2018

% Anlegen der tf-variable (hier z, es sind aber
% auch andere Variablennamen mglich, z.B. p
z = tf('z',1)

% Anlegen der tf-Objekte direkt als Formel in z
H1 = z/(z-1)
H2 = 2*z^0      % nicht: H2 = 2 da sonst kein tf-Objekt!
H3 = (z^2-1)/z^2

% Berechnung der bertragungsfunktion durch direkte
% Umsetzung der analytisch berechneten bertragungs-
% funktion
% (Alternative Berechnung siehe bspUebFunkt_tf)
H = H1*H2/(1+H1*H2*H3)

% Bereinigung um eventuell gleiche Pol-Nullstellenpaare
H = minreal(H)

% Numerische Berechnung der Impulsantwort
% Zeitpunkte definieren (hier ganzzahlig)
n = (0:1:20);

% Impulsantwort bestimmen
[imant, time] = impulse(H,n)

% Impulsantwort grafisch darstellen
figure
stem(time, imant, 'b', 'LineWidth', 3)
grid
xlabel('Zeitindex/n')
ylabel('h_n')

% Impulsantwort nach der exakten Formel
% (man beachte die FELDoperation .^(n+1))!!
h = (2/5)*(1-(-2/3).^(n+1));

% Vergleich der numerischen Werte
[n',  h', imant]