% Script bsp3UebFunkt_tf
%
% Aufruf: bsp3UebFunkt_tf
%
% Zusammenfassung der Beispiele fr die Berechnung
% bertragungsfunktion digitaler LTI-Systeme mit 
% Hilfe der tf-Funktionen der Control Systems Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.11.2014/19.05.2018

% z-bertragungsfunktion definieren
H = tf([1 -3/4],[1 -1 25/36],1)

% Zeitpunkte definieren (hier ganzzahlig)
n = (0:1:40);

% Impulsantwort bestimmen
[imant, tn] = impulse(H,n);

% Sprungantwort bestimmen
[stepant, tn] = step(H,n);

% Impulsantwort plotten
figure
stem(tn,imant,'b','LineWidth',3)
grid
xlabel('Zeitindex/n')
ylabel('h_n')

figure
% Sprungantwort plotten
stem(tn,stepant,'k','LineWidth',3)
grid
xlabel('Zeitindex/n')
ylabel('y^{(\sigma)}_n')