% Skript bspFTnperiod.m
%
% Aufruf:  bspFTnperiod
%
% Beispiel zur Diskreten Fourier Transformation
% Berechnung des Spektrums des nicht-periodischen 
% Signals
%
% x(t) = sigma(t)*e^{-t}*sin(4t)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.1
% Datum: 22.03.2008/19.05.2018

% Berechnung des Spektrums mit der Symbolic Math
% Toolbox

syms t omega
x = exp(-t)*sin(4*t)*heaviside(t)
X = fourier(x,omega);
X = simplify(X, 'Steps', 100)
pretty (X)

% Berechnung des Amplitudenspektrums
Xquad = (-4/(omega^2-2*1i*omega-17))*...
                    (-4/(omega^2+2*1i*omega-17));

AspQ = simplify(Xquad, 'Steps', 100)
pretty(AspQ)

% Grafische Darstellung des Amplitudenspektrums
f = (-20:0.05:20);   % Hertz-Frequenzen
om = 2*pi*f;         % in rad/s

                     % Numerische Werte durch 
                     % Substitution
AspNum = double(subs(sqrt(AspQ), omega, om));
                     % Plot des Amplitudenspektrums
plot(f,AspNum,'b','LineWidth',3)
grid
axis([-10,10,0,0.63])
xlabel('Frequenz/Hz')
ylabel('|X|')

