% Script bspGibbs.m
%
% Aufruf: bspGibbs
%
% Skript-File zur Illustration des Gibbsschen
% Phnomens bei Bandbegrenzung
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 25.10.2014/18.05.2018

% Bandbegrenzung in Hz definieren (1. Beispiel)
f0 = 3;

% Bandbegrenzung in rad/s berechnen
omeg0 = 2*pi*f0;

% Zeitdiskretisierung festlegen
dt = 0.01;

% Zeitbereich fr die Rechteckfunktion definieren
t1 = (-5:dt:5);
rect1 = double((t1>0 & t1<1));  % Einheits-Rechteckimpuls

% Zeitbereich fr die Sinc-Funktion und 
% Sinc-Funktion definieren
t2 = (-20.0:dt:20);
sincf = (omeg0/pi)*sinc(t2*omeg0/pi);

% Faltung der Funktionen mit der MATLAB-Funktion
% conv berechnen; Skalierung mit dt zur Approximation 
% 0-ter Ordnung des Integrals (Treppenfunktion)
functg1 = dt*conv(rect1,sincf);

% Zeitbereich fr die Faltung definieren
t = (-25.0:dt:25);

% Bandbegrenzung in Hz definieren (2. Beispiel)
f0 = 21;

% Bandbegrenzung in rad/s berechnen
omeg0 = 2*pi*f0;

% sinc-Funktion definieren
sincf = (omeg0/pi)*sinc(t2*omeg0/pi);

% Faltung der Funktionen mit der MATLAB-Funktion
% conv berechnen; Skalierung mit dt zur Approximation 
% 0-ter Ordnung des Integrals (Treppenfunktion)
functg2 = dt*conv(rect1,sincf);
 
% Betragsspektrum des Zeitsignals 
% hier Einheits-Rechteckimpuls) plotten
figure
omegs = (-30:0.01:30); T = 1;
BSp = abs(T*exp(-j*omegs*T/2).*sinc(omegs*T/(2*pi)));

% gefenstertes Spektrum (Bandgrenze 3 Hz)
BSpgef = BSp.*(-2*pi*3<=omegs&omegs<=2*pi*3);
plot(omegs, BSp, 'b', omegs, BSpgef, 'k', 'LineWidth' ,3)
axis([-30,30,-0.1,1.2])
xlabel('Frequenz/rad/s')
ylabel('Y(j\omega)')
grid

% bandbegrenzte Zeitsignale plotten
figure
plot(t, functg1, 'b', t, functg2, 'k', 'LineWidth', 3);
axis([-0.4,1.4,-0.1,1.2])
grid
xlabel('Zeit/s')
ylabel('y(t)')
