% Script bspSpectFenster.m
%
% Aufruf: bspSpectFenster
%
% Skript-File zur Berechnung und Illustration eines
% gefensterten Cosinussignals
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 25.10.2014/17.05.2018

% Frequenz des Cosinus (in rad/s) definieren
omega0 = 3*2*pi;         % 3-Hz Cosinus

% Fensterlnge T definieren
T = 1;                   % Fensterdauer 1 sec

% Frequenzbereich in Hz definieren
frq = (-10:0.01:10);

% Frequenzbereich in rad/s berechnen
omega = 2*pi*frq;

% Betrags-Amplitudenspektrum des Signals ausrechnen
F1 = abs(1/2*(T*exp(-j*(omega-omega0)*(T/2)).*...   
               sinc((omega-omega0)*T/(2*pi)))+...
         1/2*(T*exp(-j*(omega+omega0)*(T/2)).*...   
               sinc((omega+omega0)*T/(2*pi))));

% neue Fensterlnge T definieren
T = 3;                   % Fensterdauer 3 sec

% Betrags-Amplitudenspektrum des Signals ausrechnen
F3 = abs(1/2*(T*exp(-j*(omega-omega0)*(T/2)).*...   
               sinc((omega-omega0)*T/(2*pi)))+...
         1/2*(T*exp(-j*(omega+omega0)*(T/2)).*...   
               sinc((omega+omega0)*T/(2*pi))));

% neue Fensterlnge T definieren
T = 100;                  % Fensterdauer "unendlich"

% Betrags-Amplitudenspektrum des Signals ausrechnen
F100 = abs(1/2*(T*exp(-j*(omega-omega0)*(T/2)).*...   
               sinc((omega-omega0)*T/(2*pi)))+...
         1/2*(T*exp(-j*(omega+omega0)*(T/2)).*...   
               sinc((omega+omega0)*T/(2*pi))));
          
% Betrge der Spektren plotten                    
subplot(311)
plot(frq, F1, 'b', 'LineWidth', 3);
grid
xlabel('Frequenz/Hz')
ylabel('|F|')
subplot(312)
plot(frq, F3, 'k', 'LineWidth', 3);
grid
xlabel('Frequenz/Hz')
ylabel('|F|')
subplot(313)
plot(frq, F100, 'r', 'LineWidth', 3);
grid
xlabel('Frequenz/Hz')
ylabel('|F|')

