% Script bspStabil_tf
%
% Aufruf: bspStabil_tf
%
% Zur Stabilittsbestimmung digitaler LTI-Systeme mit 
% Hilfe der tf-Funktionen der Control Systems Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 08.11.2014/19.05.2018

% Definition des Systems H(z)
H = tf([2 0 0],[3 -1 -2],1)

% Bereinigung um eventuell gleiche Pol-Nullstellenpaare
H = minreal(H) 

% Bestimmung von Polen und Nullstellen
polstellen = pole(H)
nullstellen = zero(H)

% Betrge der Polstellen
polbetrag = abs(polstellen)

% Berechnung der ersten 100 Werte der Sprungantwort
[spantw,n] = step(H,100);

% Sprungantwort plotten
figure
stem(n,spantw,'b','LineWidth',3)
grid
xlabel('Zeitindex/n')
ylabel('y^{(\sigma)}_n')