% Script bspUebFunkt_tf
%
% Aufruf: bspUebFunkt_tf
%
% Zusammenfassung der Beispiele fr die Berechnung
% bertragungsfunktion digitaler LTI-Systeme mit 
% Hilfe der tf-Funktionen der Control Systems Toolbox
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.11.2014/19.05.2018


% Definition des Systems H1(z)
H1 = tf([1 0],[1 -1],1)

% Definition des Systems H2(z)
H2 = tf([2],[1],1)

% Definition des Systems H3(z)
H3 = tf([1 0 -1],[1 0 0],1)

% Berechnung der bertragungsfunktion mit Hilfe der
% tf-Funktionen series, parallel, feedback
% (Alternative Berechnung siehe bsp2UebFunkt_tf)

% Berechnung der bertragungsfunktion des
% Vorwrtszweiges
Hvor = series(H1,H2)

% Berechnung der bertragungsfunktion Systems
H = feedback(Hvor,H3)

% Bereinigung um eventuell gleiche Pol-Nullstellenpaare
H = minreal(H)

% Numerische Berechnung der Impulsantwort
% Zeitpunkte definieren (hier ganzzahlig)
n = (0:1:20);

% Impulsantwort bestimmen
[imant, time] = impulse(H,n)

% Impulsantwort grafisch darstellen
figure
stem(time, imant, 'b', 'LineWidth', 3)
grid
xlabel('Zeitindex/n')
ylabel('h_n')

% Impulsantwort nach der exakten Formel
% (man beachte die FELDoperation .^(n+1))!!
h = (2/5)*(1-(-2/3).^(n+1));

% Vergleich der numerischen Werte
[n',  h', imant]

