% Script bspZRDdiskret.m
%
% Aufruf: 	bspZRDdiskret
%
% Beispiel zur Berechnung der Zustandsraumdarstellung 
% digitaler SISO-LTI-Systeme mit 
% Hilfe der ss-Funktionen der Control Systems Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 08.11.2014/19.05.2018


% Definition des SISO-LTI-Systems mit Hilfe der
% Funktion tf
a_0 = 1/2; a_1 = -1; a_2 = 1; b_0 = 3; b_1 = 1;
z = tf('z',1);
H = (b_0 + b_1*z)/(a_2*z^2  + a_1*z  + a_0)

% Berechnung einer Zustandsraumdarstellung mit Hilfe der
% Funktion ss
ZRD = ss(H);
A = ZRD.a
B = ZRD.b
C = ZRD.c
D = ZRD.d

% Von Hand berechnete Zustandsraumdarstellung
A = [0 1; -a_0/a_2 -a_1/a_2];
B = [0; 1/a_2];
C = [b_0 b_1];
D = 0;

LTISys = ss(A,B,C,D,-1)

% Umwandlung in eine bertragungsfunktion
H = tf(LTISys)

