% Script bsp_BBSys3Ord.m
%
% Aufruf: bsp_BBSys3Ord
%
% Berechnung der Impulsantwort eines LTI-Systems 3. Ordnung mit
% Hilfe der Zustandsraumdarstellung im Bildbereich.
% Zur Berechnung wird die Symbolic Math Toolbox verwendet.
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.01
% Datum: 17.10.2014/17.05.2018
 

syms t s

% Definition der Systemmatrix A
A = [0 1 0; 0 0  1;  -1/2  -1 -2]

% Berechnung der Transitionsmatrix Phi(s)
% im Bildbereich
Phis = inv(s*eye(3)-A)

% Berechnung der Impulsantwort h(t)
C = [1 0 0];
B = [0;0;1];

% bertragungsfunktion H(s)
H = C*Phis*B

% Bestimmung der Impulsantwort h(t) durch inverse
% Laplace-Transformation
h = ilaplace(H,t)

% Bestimmung der Wurzeln _alpha = RootOf....
r3s = double(solve('1+2*x+4*x^2+2*x^3'))

% Einsetzen in die Formel fr h(t)
t = (0:0.01:50);
h = 2*exp(r3s(1)*t)/(6*r3s(1)^2 + 8*r3s(1) + 2)...
      +2*exp(r3s(2)*t)/(6*r3s(2)^2 + 8*r3s(2) + 2)...
      +2*exp(r3s(3)*t)/(6*r3s(3)^2 + 8*r3s(3) + 2);
  
% Grafische Darstellung der Funktion im
% Intervall [0,50]
plot(t,h,'b','LineWidth',2)
grid
xlabel('Zeit/s')
ylabel('h(t)')