% Script bsp_BBSys3OrdCST.m
%
% Aufruf: bsp_BBSys3OrdCST
%
% Berechnung der Impulsantwort eines LTI-Systems 3. Ordnung mit
% Hilfe der Zustandsraumdarstellung im Bildbereich.
% Zur Berechnung wird die Control Systems Toolbox verwendet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 17.10.2014/17.05.2018
 

% Definition der Zustandsmatrizen
A = [0 1 0; 0 0  1;  -1/2  -1 -2];
B = [0;0;1];
C = [1 0 0];
D = 0;

% Berechnung der Zustandsraumdarstellung
ZRD = ss(A,B,C,D)

% Berechnung der bertragungsfunktion
H = tf(ZRD)

% Berechnung der Impulsantwort
x = (0:0.1:50);
h = impulse(ZRD,x);
plot(x,h,'b','LineWidth',2)
grid
xlabel('Zeit/s')
ylabel('h(t)')
