% Script bsp_ztrans
%
% Aufruf: bsp_ztrans
%
% Zammenfassung der Beispiele fr die Berechnung
% der z-Transformation mit Hilfe der Symbolic Math Toolbox.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 3.2
% Datum: 08.05.2010/19.05.2018

% Symbolische Variablen definieren
syms n z      

% Z-Transformation des Einheitssprungs
sigma = sym('1');
Sigma = ztrans(sigma);
pretty(Sigma)

% Z-Transformierte des disketen Impulses
delta0 = kroneckerDelta(n,0);
Delta0 = ztrans(delta0);
pretty(Delta0)

% Z-Transformierte eines um einen Takt
% verschobenen diskreten Impulses
delta1 = kroneckerDelta(n,1);
Delta1 = ztrans(delta1);
pretty(Delta1)

% Z-Transformierte eines um zwei Takte
% verschobenen diskreten Impulses
delta2 = kroneckerDelta(n,2);
Delta2 = ztrans(delta2);
pretty(Delta2)

% Z-Transformierte einer Potenzfolge
syms a
x = a^n
X = ztrans(x);
pretty(X)

% Z-Transformierte eines Cosinussignals
syms f T
x = cos(2*pi*f*n*T)
Xcos = ztrans(x);
pretty(Xcos)

% Z-Transformierte eines Simussignals
y = sin(2*pi*f*n*T)
Xsin = ztrans(y);
pretty(Xsin)
