% Script bspbodeDiag.m
%
% aufruf: bspbodeDiag
%
% Skript-File zur Bestimmung des Bode-Diagramms
% eines RC-Tiefpasses mit Zeitkonstante T
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 25.10.2014/18.05.2018

% bertragungsfunktion des RC-Tiefpass
% definieren
T = 1;
s = tf('s');
H = 1/(s+1);

% Frequenzvektor in rad/s definieren
omegs = (0:0.1:20);

% Bode-Diagramm berechnen
[Ampg,phasg] = bode(H,omegs);

% Plot des Bode-Diagramms ("von Hand"
% Ohne die Rckgabewerte wird der Plot
% automatisch ausgefhrt ist aber nicht so
% flexibel)
Ampg = Ampg(:);       % Vektor erzeugen
phasg = phasg(:);     % Vektor erzeugen

subplot(211)
semilogx(omegs, 20*log10(Ampg), 'b', 'Linewidth',3);
grid
axis([0, omegs(end), min(20*log10(Ampg))-3,max(20*log10(Ampg))+3])
xlabel('Frequenz/rad/s')
ylabel('dB')

subplot(212)
semilogx(omegs, phasg, 'k', 'Linewidth',3);
grid
axis([0, omegs(end), min(phasg),max(phasg)])
xlabel('Frequenz/rad/s')
ylabel('rad')
