% Script-File butterwBsp.m
%
% Aufruf: butterwBsp
%
% Realisierung des Butterworth-Filters aus
% Beispiel 1.38 Lehrbuch
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 19.04.2018/19.05.2018

% a-Koeffizientenvektor
A = [1/(2+sqrt(2)), 2/(2+sqrt(2)), 1/(2+sqrt(2))];
% B-Koeffizientenvektor
B = [1 0 (2-sqrt(2))/(2+sqrt(2))];

% Impulssignal der Lnge N
N = 10;
dn = zeros(1,N); dn(1) = 1;

% Impulsantwort (beachte: die Namensgebung A,B
% der Hilfe zu filter ist gerade anders herum)
impant = filter(A,B,dn);

figure
subplot(121)
% Impulsantwort darstellen
stem((1:N),impant,'b','Linewidth',3)
xlabel('n / Index')
ylabel('|h_n|')
axis([1,N,-0.2,0.65])
grid

% bertragungsfunktion berechnen
Oms = (-pi:0.01:pi);
H = freqz(A,B,Oms);
subplot(122)
plot(Oms,abs(H), 'b', 'LineWidth',3);
xlabel('Normierte Frequenz / rad')
ylabel('|H|')
axis([-pi,pi,0,1.1])
grid