% Skript fensterDFT.m
%
% Aufruf:  fensterDFT
%
% Darstellung der Charakteristiken der
% gngigen Fensterfolgen fr die DFT
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018

N = 16;                     % Fensterlnge festlegen
M = 2048;                   % Zero-Padding-Lnge
k = (0:1:N-1);

%%% Rechteckfenster
figure                      % Plot des Rechteck-Fensters        
stem(k,rectwin(N),'b','LineWidth',3);  
grid
axis([0,16,0,1.2])          % Grafikachsen anpassen
xlabel('n');
title('Rechteck-Fenster')

y = fft(rectwin(N),M);      % Berechnung des Fensterspektrums
                            % Zero-Padding zur Glttung verw.
max = abs(y(1));            % Bestimmung des Betragsmaximums
                            % (stets bei 0 rad) zur Normierung
                            % auf 0 dB
sp = abs(y)/max+0.00001;    % Absolutbetrag des Spektrums
                            % Term 0.00001 zur Elimination von
                            % Nullen (stren bei log10-Bildung)
dom = 2*pi/M;
Omega = (0:dom:pi-dom);     % Frequenzbereich der Darstellung
spteil = sp(1:length(Omega)); % Betragsspektrum ber diesem Ber.

figure                      % Plot Betragsspektrums (in dB)  
plot(Omega,20*log10(spteil), 'k', 'LineWidth',3)
grid
axis([0,pi,-100,0])         % Grafikachsen anpassen
xlabel('Omega/rad');
ylabel('dB');
title('Betragsspektrum Rechteck-Fenster')



%%% Hanningfenster
figure                      % Plot des des Hanning-Fensters
stem(k,hanning(N),'b','LineWidth',3); 
grid
axis([0,16,0,1.2])          % Grafikachsen anpassen
xlabel('n');
title('Hanning-Fenster')


y = fft(hanning(N),M);      % Berechnung des Fensterspektrums
                            % Zero-Padding zur Glttung verw.
max = abs(y(1));            % Bestimmung des Betragsmaximums
                            % (stets bei 0 rad) zur Normierung
                            % auf 0 dB
sp = abs(y)/max+0.00001;    % Absolutbetrag des Spektrums
                            % Term 0.00001 zur Elimination von
                            % Nullen (stren bei log10-Bildung)
dom = 2*pi/M;
Omega = (0:dom:pi-dom);     % Frequenzbereich der Darstellung
spteil = sp(1:length(Omega)); % Betragsspektrum ber diesem Ber.
figure                      % Plot Betragsspektrums (in dB)  
plot(Omega,20*log10(spteil), 'k', 'LineWidth',3)
grid
axis([0,pi,-100,0])         % Grafikachsen anpassen
xlabel('Omega/rad');
ylabel('dB');
title('Betragsspektrum Hanning-Fenster')


%%% Blackmanfenster
figure                      % Plot des Blackman-Fensters
stem(k,blackman(N),'b','LineWidth',3);  
grid
axis([0,16,0,1.2])          % Grafikachsen anpassen
xlabel('n');
title('Blackman-Fenster')


y = fft(blackman(N),M);      % Berechnung des Fensterspektrums
                            % Zero-Padding zur Glttung verw.
max = abs(y(1));            % Bestimmung des Betragsmaximums
                            % (stets bei 0 rad) zur Normierung
                            % auf 0 dB
sp = abs(y)/max+0.00001;    % Absolutbetrag des Spektrums
                            % Term 0.00001 zur Elimination von
                            % Nullen (stren bei log10-Bildung)
dom = 2*pi/M;
Omega = (0:dom:pi-dom);     % Frequenzbereich der Darstellung
spteil = sp(1:length(Omega)); % Betragsspektrum ber diesem Ber.
figure                      % Plot Betragsspektrums (in dB)  
plot(Omega,20*log10(spteil), 'k', 'LineWidth',3)
grid
axis([0,pi,-100,0])         % Grafikachsen anpassen
xlabel('Omega/rad');
ylabel('dB');
title('Betragsspektrum Blackman-Fenster')



%