% Skript fensterDFTbsp.m
%
% Aufruf:  fensterDFTbsp
%
% Beispiel fr die Auswirkung der Fenstertechnik
% bei Leakage
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018

N = 32;                     % Fensterlnge festlegen
T = 1/16; fa = 1/T;         % Abtastintervall/rate festlegen
t = (0:T:(N-1)*T);          % Abtastzeitpunkte festlegen
frq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor festlegen
xn = cos(2*pi*3.7*t);       % Abtastwerte einer Cosinusschwingung mit
                            % Frequenz 3.7 Hz bestimmen
Spec = fft(xn);             % fft (DFT) berechnen

%%% Spektrum darstellen
figure                      % Plot des Rechteck-Fensters        
stem(frq,abs(Spec),'b','LineWidth',3);  
axis([0,16,0,14])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei Verwendung des Rechteck-Fensters');

% DFT mit Blackman-Fensterung berechnen
Spec = fft(xn.*(blackman(N)'));

%%% Spektrum darstellen
figure                      % Plot des Rechteck-Fensters        
stem(frq,abs(Spec),'b','LineWidth',3);  
axis([0,16,0,8])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei Verwendung des Blackman-Fensters');


%