% Script init_YuleWalkFahrbahn
%
% Initialisiert fr das Simulink-File
%
%       s_YuleWalkFahrbahn.slx
%
% die Parameter:
%
% simudauer          Simulationsdauer
% fa                 Abtastrate
% b                  Zhlerkoeffizientenvektor des IIR-Filters
% a                  Nennerkoeffizientenvektor des IIR-Filters
%
% Es wird mit Hilfe der Yule-Walker-Methode ein Filter
% berechnet, mit dem auf der Grundlage des Wiener-Lee-Theorems
% ein Fahrbahnunebenheitssignal erzeugt werden kann.
%
% Die spektrale Leistungsdichte des zugehrigen 
% zeitkontinuierlichen Signals soll
%
%      S_XX(rho) = (1/rho)^(1.75)
%
% sein (raue Fahrbahn)
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_YuleWalkFahrbahn.slx durch Mausclick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 28.11.2014/21.05.2018


fa = 100;        % Abtastrate in 1/m
dt = 1/fa;       % Abtastintervall = sample time

F = (0:0.01:0.1);% Frequenzvektor normiert auf die halbe
                 % Abtastrate (1 entspricht fa/2)
                 %(Auflsung erhht zwischen 0 un 0.1)
F = [F,(0.2:0.1:1)];
                 
Omega = F*pi;    % normierte Frequenz in rad
                 % pi entspricht Abtastrate/2
                 
                 % gewnschte Filtercharakteristik
magn = sqrt(fa)*(1./(Omega*fa)).^(1.75/2); 


magn(1) = magn(2); % da sonst magn(1)=Inf und die
                 % Anpassung schwierig wird
order = 8;       % gewhlte Filterordnung
                 % Berechnung der Filterkoeffizienten
[b,a] = yulewalk(order,F,magn);

simudauer = 1000;  % Dauer der Simulation 

% Parameter im System s_YuleWalkFahrbahn.slx mit set_param setzen
open_system('s_YuleWalkFahrbahn');
rng('shuffle', 'twister')
   zufall = floor(rand(1)*32000)+1;  
   
% Rauschblock
set_param('s_YuleWalkFahrbahn/Rauschquelle', 'Cov', num2str(dt));
set_param('s_YuleWalkFahrbahn/Rauschquelle', 'Ts', num2str(dt));
set_param('s_YuleWalkFahrbahn/Rauschquelle', 'seed', num2str(zufall));

% Filter-Block
set_param('s_YuleWalkFahrbahn/Filter', 'Numerator', ['[',num2str(b),']']);
set_param('s_YuleWalkFahrbahn/Filter', 'Denominator', ['[',num2str(a),']']);

% System
set_param('s_YuleWalkFahrbahn', 'StopTime', num2str(simudauer));
set_param('s_YuleWalkFahrbahn', 'FixedStep', num2str(dt));

