% Script init_blwnoise.m
%
% Initialisiert fr das Simulink-File
%
%       s_blwnoise.slx
%
% Die Parameter:
%
% simudauer        Simulationsdauer
% stime            Schrittweite einer Fixed-Step Simulation
% ndichte          Leistungsdichte des Rauschens
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_blwnoise.slx durch Mausklick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 22.11.2014/20.05.2018

stoptime = 10;     % Simulationsdauer
stime = 0.01;      % 1/simulierte Abtastrate
ndichte = stime;   % Leistungsdichte des Rauschens

fixstep = stime;   % Schrittweite der Fixed-Step Simulation

set_param('s_blwnoise','FixedStep',num2str(fixstep));
set_param('s_blwnoise','StopTime',num2str(stoptime));
                  
                  % Rauschblockparameter definieren
set_param('s_blwnoise/Rauschsignal','TS',num2str(stime) );
set_param('s_blwnoise/Rauschsignal','cov',num2str(ndichte));
    


