% Script init_lininv.m
%
% Initialisiert fr das Simulink-File
%
%       s_lininv.slx
%
% die Parameter:
%
% stoptime         Simulationsdauer
% fixstep          Schrittweite einer Fixed-Step Simulation
% K                Proportionalittskonstante
% amp              Amplitude einer sinusfrmigen Anregung
%                  um den Arbeitspunkt herum
% frq              Frequenz (Hz) der sinusfrmigen Anregung
%                  um den Arbeitspunkt herum
%
% Die Werte der Parameter mssen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_lininv.slx durch Mausklick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.8.2014/17.05.2018

stoptime = 10;     % Simulationsdauer
fixstep = 0.01;    % Schrittweite einer Fixed-Step Simulation
K = 1;             % Proportionalittskonstante
amp = 1.0;         % Amplitude einer sinusfrmigen Anregung
                   % um den Arbeitspunkt herum
frq = 1;           % Frequenz (Hz) der sinusfrmigen Anregung
                   % um den Arbeitspunkt herum

