% Script init_onetonefilt.m
%
% Initialisiert fr das Simulink-File
%
%       s_onetonefilt.mslx
%
% zur Simulation eines Sinus in weiem Rauschen und dessen
% Filterung durch ein Butterworth-Tiefpass-Filter.
%
% Die Parameter:
%
% simudauer        Simulationsdauer
% stime            Schrittweite (1/Abtastrate)
% frq              Frequenz des Sinus in Hz
% ampl             Amplitude des Sinus
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_onetonefilt.slx durch Mausklick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 27.11.2014/20.05.2018

simudauer = 50;    % Simulationsdauer
ampl = 0.1;        % Amplitude des Sinus
frq = 50;          % Frequenz des Sinus in Hz
stime = 1/1000;    % Schrittweite (1/Abtastrate)
    


