% Script init_viertelkfzDGL4.m
%
% Initialisiert fr das Simulink-File
%
%       s_viertelkfzDGL4.slx
%
% die Parameter:
%
% stoptime         Simulationsdauer
% fixstep          Schrittweite einer Fixed-Step Simulation
% m1,m2            Massen
% c1,c2            Federkonstanten
% d                Dmpfungskonstante
% bordstein        Sprunghhe des Sprungsignals (Eingangssignal)
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_viertelkfz.slx bzw. s_viertelkfzDGL4.slx
% durch Mausclick vor der Simulation initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 03.09.2014/17.05.2018

stoptime = 1;      % Simulationsdauer
fixstep = 0.001;   % Schrittweite einer Fixed-Step Simulation
steptime = 0.05;   % Zeitpunkt des Sprungs
bordstein = 0.15;  % Sprunghhe

% Werte nach Steffani (www.steffani.de/hfst/simulation/folie.pdf)
mA = 186;         % Masse A (Aufbau in Kg) % teste z.B. auch 65 Kg
mR = 41;          % Masse R (Rad in Kg)
cA = 41.1*10^3;   % Feder 1 (Aufbau in N/m)
cR = 380*10^3;    % Feder 2 (Rad in N/m)
d = 25.0*10^2;    % Dmpfung (Aufbau in Ns/m) 
                  % teste z.B. auch 5.833*10^3, 5.833*10^2

a1 = -cA/mA;
a2 = -d/mA;
b1 = cA/mR;
b2 = d/mR;
gamma = cR/mR;
