function varargout = make_audio(varargin)
% MAKE_AUDIO M-file for make_audio.fig
%
% Kommando: [sound, FS] = make_audio;
%
% Dies ist das m-File fr das GUI make_audio
%
% ffnet ein GUI, das mit Start die Aufnahme eines
% Signals ber den Mikrophon-Eingang erlaubt. Mit Stop
% und OK wird das Signal in sound gespeichert.
% Zugleich wird die Abtastrate FS zurckgeliefert.
%
% Optional kann das Signal vorher mit Save in einem 
% *.wav-File gespeichert werden.
%
% Autor:    Prof. Dr. Ottmar Beucher
%           HS Karlsruhe 
% Version:  2.2
% Datum:    17.5.2009/20.05.2018

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @make_audio_OpeningFcn, ...
                   'gui_OutputFcn',  @make_audio_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before make_audio is made visible.
function make_audio_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to make_audio (see VARARGIN)

% Choose default command line output for make_audio
handles.output = hObject;

% handles.SicherungWavFile = get(handles.NameSicherungWavFile, 'String');

% Audiorecorderobjekt anlegen und double-Vektor initialisieren
handles.SampleRate = 22050;
handles.RecordObject = audiorecorder(handles.SampleRate, 16, 1);
handles.SoundVektor = [];
handles.SicherungWavFile = get(handles.NameSicherungWavFile , 'String');

% Blockierung aller anderen Fenster (ntig?)
%set(hObject, 'WindowStyle', 'modal');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes make_audio wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = make_audio_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


varargout{1} = handles.SoundVektor;
varargout{2} = handles.SampleRate;

delete(handles.figure1);
% Get default command line output from handles structure




% --- Executes on button press in OK.
% --- Setzt die Parameter im Simulink-File bei Druck auf OK
function OK_Callback(hObject, eventdata, handles)
% hObject    handle to OK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% varargout{1} = handles.RecordObject;
% varargout{2} = getaudiodata(handles.RecordObject, 'double');

figure1_CloseRequestFcn(handles.figure1, eventdata, handles)




% --- Executes when user attempts to close figure1.
% Rckspeichern der Strukturwerte in Figur, dami diese
% beim nchsten Aufruf wider ztur Verfgung stehen
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% Audioobjekt vor Speichern lschen
% handles = rmfield(handles, 'RecordObject');
% % Speichern
% saveas(hObject,'make_audio.fig');
uiresume(handles.figure1);
% saveas(hObject,'make_audio.fig');
% Hint: delete(hObject) closes the figure
% delete(hObject);


% --- Executes on button press in StartAufnahme.
function StartAufnahme_Callback(hObject, eventdata, handles)
% hObject    handle to StartAufnahme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

record(handles.RecordObject);
guidata(hObject, handles);


% --- Executes on button press in StopAufnahme.
function StopAufnahme_Callback(hObject, eventdata, handles)
% hObject    handle to StopAufnahme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

stop(handles.RecordObject);
handles.SoundVektor = getaudiodata(handles.RecordObject, 'double');
% wavwrite(handles.SoundVektor,22050,16,handles.SicherungWavFile);
guidata(hObject, handles);



function NameSicherungWavFile_Callback(hObject, eventdata, handles)
% hObject    handle to NameSicherungWavFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.SicherungWavFile = get(hObject, 'String');

guidata(hObject, handles);
% Hints: get(hObject,'String') returns contents of NameSicherungWavFile as text
%        str2double(get(hObject,'String')) returns contents of NameSicherungWavFile as a double


% --- Executes during object creation, after setting all properties.
function NameSicherungWavFile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NameSicherungWavFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in SaveButton.
function SaveButton_Callback(hObject, eventdata, handles)
% hObject    handle to SaveButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if ~isempty(handles.SoundVektor)
    wavwrite(handles.SoundVektor,22050,16,handles.SicherungWavFile)
else
    errordlg('Noch keine Aufnahme vorhanden');
end

%     
% guidata(hObject, handles);

