function [F, Pxx] = psddft(signal, block, f, abtastrate)
%
% Aufruf:  [F, Pxx] = psddft(signal, block, f, fabtast )
%
% Aufrufbeispiel:  [F, Pxx] = psddft(signal, 4000, (0:0.01:10), 5000 )
%
% liefert das Leistungsdichtespektrum an den Stellen f (Frequenzvektor)
% zum diskreten Signal signal, abgetastet mit abtastrate
%
% Der Vektor Pxx enthlt das Leistungsdichtespektrum
% Der Vektor F ist eine Kopie von f.
%
% Das Leistungsdichtespektrum wird dabei NICHT mit einer 
% FFT berechnet, damit der Wert an BELIEBIGEN, durch den Frequenzvektor
% f vorgegebenen Stellen bestimmt werden kann.
%
% Mit Hilfe des Parameters block wird bestimmt, wieviele
% Werte fr die Berechnung der DFT herangezogen werden.
% Enthlt signal mehr Werte, so wird ber hintereinander
% liegende Blcke gemittelt, hnlich wie beim Welch-Periodogramm.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.02
% Datum: 28.11.2014/21.05.2018

% Zahl der Mittelungen bestimmen
NMittel = floor(length(signal)/block)+1;

% Frequenzen in rad
F = f(:);           % Ausgangsfrequenzvektor als Spaltenvektor
f = F';             % f als Zeilenvektor
Omega=2*pi*f./abtastrate; 

% Berechnung der Werte -j*Omega
expo= -1i*Omega;

% Matrix, in deren Zeilen -j*k*Omega steht
ind=(0:block-1);
m=ind'*expo;

% Matrix in deren Zeilen exp(-j*k*Omega steht)
expant=exp(m);

% Pxx vorinitialisieren
Pxx = zeros(size(F));

signal = signal(:); 
signal = [signal', zeros(1, NMittel*block-length(signal))];

% Leistungsdichte schtzen
for k = 1:NMittel
   sigAusschnitt = signal( (k-1)*block+1:k*block);
   DFT = sigAusschnitt*expant;
   Pxx = Pxx+(abs(DFT').^2);
end

Pxx = Pxx/(block*abtastrate);


