function [yn] = rec_formel(xn)
%
% Aufruf: [yn] = rec_formel(xn)
%
% Beispielaufruf: [yn] = rec_formel([1,zeros(1,29)])
%
% Berechnet die Antwort yn eines digitalen Systems, welches 
% durch die Rekursionsformel 
%
%       y_n = y_{n-1} - 25/36*y_{n-2} + x_{n} - 3/4*x_{n-1}.
%
% gegeben ist auf ein Eingangssignal xn.
%
% Eingangsparameter:     xn       Vektor der Eingangssignalwerte
%
% Ausgangsparameter:     yn       Vektor der Ausgangssignalwerte
%
% Die Anfangswerte y_{n-1}, y_{n-2} fr n=0 werden dabei als
% 0 angenommen, d.h. das System ist zu Beginn "in Ruhe".
% Das Eingangssignal x_{n} wird als KAUSAL angenommen, d.h.
% x_{-1} ist 0.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 04.11.2014/19.05.2018


N = length(xn);             % Zahl der Sttzstellen
                            % Vorinitialisierung mit 
                            % den Anfangswerten
yn = [0, 0, zeros(1,N)];  
                            % Bercksichtigung von x_{-1}
xn = [0, xn];

% die Rekursionsformel
for k=1:N
    yn(k+2) = yn(k+1) - 25/36*yn(k) + xn(k+1) - 3/4*xn(k);
end

% Elimination der knstlich eingefgten Nullen
yn(1:2) = []; xn(1) = [];

% Grafische Darstellung der Simulation
figure
t = cumsum(ones(1,length(xn)))-1;
subplot(211)
stem(t,xn,'k','LineWidth',2);
grid
xlabel('Index/n')
ylabel('Amp')
title('Eingangssignalfolge x_n');
subplot(212)
stem(t,yn,'b','LineWidth',2);
grid
xlabel('Index/n')
ylabel('Amp')
title('Systemantwort y_n');