function rauschprozess = rp1(M,N)
%
% Aufruf:  rauschprozess = rp1(M,N)
%
% Liefert mit Hilfe der Funktion rand eine MxN-Matrix, bestehend
% aus M Zufallssignalen mit N diskreten Werten. Die Zufallssignale
% sind gleichverteilt im Intervall [0,1].
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 3.2
% Datum: 19.11.2014/20.05.2018

% fest gewhlte Parameter
a = 0.02;
b = 5;					

% Zufallsgenerator initialisieren
rng('shuffle', 'twister')

% Zufallsprozess erzeugen
MC = ones(M,1)*b*sin((1:N)*pi/N);
AC = a*ones(M,1)*[1:N];
rauschprozess = (rand(M,N)-0.5).*MC+AC; 