% Skript schnellFalt1.m
%
% Aufruf:  schnellFalt1
%
% Beispiel fr eine Faltung zweier endlicher Folgen
% mit Hilfe eines Schleifenkonstrukts und mit Hilfe
% der DFT/FFT (schnelle Faltung)
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 13.11.2014/19.05.2018

% Definition zweier endlicher Folgen
x = [ 1 2 3 2 1];
y = [ -1 1 3 1];

% Lnge der Folgen
N = length(x); M = length(y);

% Vorinitialisierung der Faltung
Fxy = zeros(1,M+N-1);

% Berechnung der Faltung mit einem 
% Schleifenkonstrukt (ineffektiv)
for n = 0:N+M-2
    for k = 0:N-1
        s= n-k;
        if s>=0 & s<M
            % beachte: Indizierung in MATALB ab 1
            Fxy(n+1) = Fxy(n+1)+x(k+1)*y(s+1);
        end
    end
end

% Bildschirmausgabe
Fxy

% Vergleich mit einer "schnellen Faltung"
% DFTs der erweiterten Folgen berechnen
Spx = fft(x,M+N-1);   % x wird automatisch auf die Lnge
                      % N+M-1 mit Nullen erweitert
Spy = fft(y,M+N-1);

% Rcktransformation berechnen
Fxyfast = ifft(Spx.*Spy)



