% Skript schnellFalt2.m
%
% Aufruf:  schnellFalt2
%
% Beispiel fr eine Faltung zweier (langer) endlicher Folgen
% mit Hilfe eines Schleifenkonstrukts und mit Hilfe
% der DFT/FFT (schnelle Faltung) zum Vergleich der Berechnungs-
% geschwindigkeiten
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.01
% Datum: 13.11.2014/19.05.2018

% Definition zweier langer endlicher Folgen
N = 64*1024; M = 32*1024;
n = (0:1:N-1); m = (0:1:M-1);
x = sin(2*pi*n/1024);
y = cos(2*pi*3*m/1024);

tic;  % Zeitmessung ein
fprintf('\nDie direkte Faltung wird berechnet!\nBitte warten!\n\n');

% Vorinitialisierung der Faltung
Fxy = zeros(1,M+N-1);

% Berechnung der Faltung mit einem 
% Schleifenkonstrukt (ineffektiv)
for n = 0:N+M-2
    for k = 0:N-1
        s= n-k;
        if s>=0 & s<M
            % beachte: Indizierung in MATLAB ab 1
            Fxy(n+1) = Fxy(n+1)+x(k+1)*y(s+1);
        end
    end
end

% Bildschirmausgabe (teilweise)
Fxy(100:110)

toc;  % Zeitmessung aus


fprintf('\nFr schnelle Faltung bitte Taste drcken!\n\n');
pause

tic;  % Zeitmessung ein

% Vergleich mit einer "schnellen Faltung"
% DFTs der erweiterten Folgen berechnen
Spx = fft(x,M+N-1);   % x wird automatisch auf die Lnge
                      % N+M-1 mit Nullen erweitert
Spy = fft(y,M+N-1);

% Rcktransformation berechnen
Fxyfast = ifft(Spx.*Spy);
Fxyfast(100:110)
toc;  % Zeitmessung aus


