function [] = vglDFTvsFT(T,N)
%
% Aufruf:  vglDFTvsFT(T,N)
%
% Beispielaufruf: vglDFTvsFT(1/9,8)
%
% Vergleich einer DFT mit dem Fourierspektrum des
% (gefensterten) Zeitsignals
%
% Eingangsparameter:     T   Abtastintervallnge
%                        N   Anzahl der Abtastwerte
%
% Ausgangsparameter:     keine
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 3.1
% Datum: 14.11.2014/19.05.2018


t = (0:T:(N-1)*T);            % Abtastzeitpunkte festlegen
fa = 1/T;                     % Abtastrate definieren
xn = cos(2*pi*t);             % Abtastwerte einer Cosinusschwingung mit
                              % Frequenz 1 Hz bestimmen
Spec = fft(xn,N);             % fft berechnen
Spec = fftshift(Spec);        % Spektrum ber [-fa/2,fa/2] darstellen

                              % Frequenzvektor in Hz definieren
nfreq = (-fa/2:fa/N:-fa/2+(N-1)*fa/N);                            
                              % Betrag der DFT in Form eines 
                              % Stabdiagramms darstellen
figure
stem(nfreq, abs(Spec), 'b', 'LineWidth',3)    
hold                          % Plot einfrieren

% Fourierspektrum berechnen
cfreq = (-fa/2:0.01:fa/2);    % Frequenzvektor in Hz
omega = 2*pi*cfreq;

omega0= 2*pi;
FSpec = (1/2)*(N*T*exp(-1i*(omega-omega0)*N*T/2).*...
sinc((omega-omega0)*N*T/(2*pi)) +...
N*T*exp(-1i*(omega+omega0)*N*T/2).*...
sinc((omega+omega0)*N*T/(2*pi))); 

                              % und plotten
plot(cfreq, fa*abs(FSpec), 'k', 'LineWidth',2)
grid
axis([-fa/2,fa/2,0,max([fa*abs(FSpec),abs(Spec)])+1])
xlabel('Frequenz / Hz')
ylabel('FT/DFT')



