% Script-File wasserrauschen.m
%
% Kommando:   wasserrauschen
%
% Das Skript berechnet die Grafik der momentanen Amplituden
% des Wasserhahn-Geruschs wasser2.mat (gleich mit wasser2.wav) 
%
% Darber hinaus werden empirische Verteilung und empirische
% Verteilungsfunktion der Amplituden berechnet und grafisch dargestellt!
% An die empirische Verteilung wird eine Normalverteilungsdichte angepasst.
%
% Deweiteren wird das LEISTUNGSDICHTESPEKTRUM des Gerusches
% mit Hilfe von cpad geschtzt und grafisch dargestellt.
%
% Autor:    Prof. Dr. Ottmar Beucher
%           HS Karlsruhe 
% Version:  1.2
% Datum:    30.1.2011/20.05.2018

% Laden des Datenfiles mit der Aufnahme des Gerusches

load wasser2.mat

% Lnge der Aufnahme und Abtastzeitpunkte bestimmen
N = length(wasser2r);
dt = 1/FS;               % FS = Abtastrate 
t = (0:dt:(N-1)*dt);

% Signal grafisch darstellen
figure
plot(t, wasser2r, 'b', 'Linewidth', 2);
axis([0, (N-1)*dt,-0.07,0.07])
grid
xlabel('Zeit/s')
ylabel('Normalisierter Schalldrck')
title('Gerusch des Wassers')

% Ausschnittsvergrerung des Signals

figure
plot(t, wasser2r, 'b', 'Linewidth', 2);
axis([1, 1+150*dt,-0.02,0.02])
grid
xlabel('Zeit/s')
ylabel('Normalisierter Schalldrck')
title('Gerusch des Wassers')

% Die empirische Verteilung der (normalisierten)
% Schalldrcke

% Klassenmitten definieren und Verteilung berechnen
bins = (-0.06:0.002:0.06);
[N2, X, PDF, CDF] = distempStetig(wasser2r, bins, 0);

% Empirische Verteilung
figure
subplot(211)
bar(bins, PDF, 0.8);  
axis([-0.03,0.03, 0, 1.1*max(PDF)]);
grid
set(gca, 'FontSize', 12);
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
xlabel('Normalisierte Schalldrcke')
ylabel('Emp. Vert.')
title(['Verteilung der (normalisierten) Schalldrcke'])

subplot(212)
xvals = [bins(1)-1 , bins(:)', bins(end)+1];
stairs(xvals, CDF, 'r', 'LineWidth', 3);
axis([-0.03,0.03, 0, 1.1*max(CDF)]);
set(gca, 'FontSize', 12);
grid
xlabel('Normalisierte Schalldrcke')
ylabel('Emp. Vert.fkt.')


% Normalverteilungsdichte mit Hilfe der Funktion
% lsqcurvefit der Optimization Toolbox an die empirische
% Verteilung anpassen. Die Funktion wird mit dem
% empirischen Mittelwert mean(wasser2) und der empirischen
% Streuung std(wasser2) initialisiert

% Normalverteilungsdichte als anonyme Funktion redefinieren
fnv = @(params,xdata) normpdf(xdata,params(1),params(2));
params = lsqcurvefit(fnv,[mean(wasser2r), std(wasser2r)],bins,PDF)

% Angepasste Verteilungsdichte ber die 
% empirische Verteilung plotten
subplot(211)
hold
h = plot(bins, normpdf(bins,params(1),params(2)), 'r', 'LineWidth', 3);
legend(h, ['\mu=',num2str(params(1)),',   \sigma=',num2str(params(2))]);
grid
axis([-0.03,0.03, 0, 1.1*max(PDF)]);
grid

% Schtzung und grafische Darstellung des (einseitigen) 
% Leistungsdichtespektrums. Es werden
% nach der Welch-Methode hlftig berlappende 1-K-
% Periodogramme verwendet.

[Pww,F] = cpsd(wasser2r,wasser2r,hanning(1024),512,1024,FS,'onesided');
Pm = mean(Pww);
figure
plot(F,10*log10(Pww),'b','LineWidth',2);
hold
h=plot(F,10*log10(Pm*ones(size(Pww))),'r','LineWidth',4);
legend(h, [num2str(10*log10(Pm)),'  dB']);
grid
axis([0,FS/2,-110,0])
xlabel('Frequenz/Hz')
ylabel('Sxx')
title('Leistungsdichtespektrum des Wassergerusches')
