% Skript zeroPaddbsp.m
%
% Aufruf:  zeroPaddbsp
%
% Beispiel fr die Auswirkung der 
% Zero-Padding-Technik
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/19.05.2018

N = 16;                     % Fensterlnge festlegen
T = 1/16; fa = 1/T;         % Abtastintervall/rate festlegen
t = (0:T:(N-1)*T);          % Abtastzeitpunkte festlegen
frq = (0:fa/N:(N-1)*fa/N);  % Frequenzvektor festlegen

% Abtastwerte der berlagerung zweier Sinusschwingungen mit
% Frequenz 1 Hz und 1.02 Hz bestimmen
xn = sin(2*pi*1*t)+sin(2*pi*1.02*t);   
Spec = fft(xn);             % fft (DFT) berechnen

%%% Spektrum darstellen

figure                      % Plot des Spektrums     
stem(frq,abs(Spec),'b','LineWidth',3);  
axis([0,8,0,20])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei 16 Abtastwerten');

%%% Spektrale Auflsungserhhung durch Erhhung der
%%% Abtastwertezahl
M = 4096;                   % Fensterlnge auf 4K festlegen
t2 = (0:T:(M-1)*T);         % Abtastzeitpunkte festlegen
frq2 = (0:fa/M:(M-1)*fa/M); % Frequenzvektor festlegen

% Abtastwerte der berlagerung zweier Sinusschwingungen mit
% Frequenz 1 Hz und 1.02 Hz bestimmen
xn2 = sin(2*pi*1*t2)+sin(2*pi*1.02*t2);       
Spec2 = fft(xn2);           % fft (DFT) berechnen

%%% Spektrum darstellen

figure                      % Plot des Spektrums     
plot(frq2,abs(Spec2),'b','LineWidth',3);  
axis([0.8,1.1,0,2200])      % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum bei 4096 Abtastwerten');


%%% Spektrale "Auflsungs"erhhung durch ZERO-PADDING
% alte Abtastwerte mit Nullen auffllen
xn3 = [xn,zeros(1,M-length(xn))]; 
Spec3 = fft(xn3);          % fft (DFT) berechnen, 
                           % alternativ einfach fft(xn3,M) !!!

%%% Spektrum darstellen
figure                    % Plot des Spektrums     
plot(frq2,abs(Spec3),'b','LineWidth',3);  
axis([0,8,0,20])          % Grafikachsen anpassen
grid
xlabel('Frequenz/Hz');
ylabel('|DFT|');
title('Amplitudenspektrum Zero-Padding auf 4096 Werte');





%