% Script  Bsp_FormFiltUeb.m
%
% Aufruf:  Bsp_FormFiltUeb
%
% bungsaufgabe zur Formfilterung auf
% der Grundlage des Wiener-Lee-Theorems.
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.01
% Datum: 26.11.2014/25.05.2018


% Initialisierung des Simulink-Systems
% s_FormFiltUeb zur Formfilterung
init_FormFiltUeb
open('s_FormFiltUeb');

% Ausfhrung des Simulink-Systems
[t,x,signal] = sim('s_FormFiltUeb');

anz = 100;        % Mittelung der Autokorrelierten
xcout = xcorr(signal, 'biased')/anz;

for i=2:anz 
% Zufallsgenerator initialisieren
rng('shuffle', 'twister') 
zufall = floor(rand(1)*32000)+1;  
set_param('s_FormFiltUeb/Rauschquelle', 'seed', num2str(zufall));

% Ausfhrung des Simulink-Systems
[t,x,signal] = sim('s_FormFiltUeb');

% Berechnung der Autokorrelationsfunktion
% des Ausgangssignals
xc = xcorr(signal, 'biased')/anz;
xcout = xcout+xc;
end

% Zeitvektor dazu berechnen
T = simudauer;     % s. init_FormFiltUeb
dt = 1/fa;         % s. init_FormFiltUeb
ct = (-T:dt:T);

% Darstellung der Autokorrelationsfunktion
plot(ct, xcout, 'r', 'LineWidth', 2);
grid
xlabel('\tau / s')
ylabel('r_{XX}(\tau)')

% Zum Vergleich die gewnschte Autokorrelationsfunktion
hold
plot(ct, exp(-abs(ct))/fa, 'k--', 'LineWidth', 2);


