% Script  Bsp_SysIdentUeb.m
%
% Aufruf:  Bsp_SysIdentUeb
%
% bungsaufgabe zur Systemidentifikation auf
% der Grundlage des Wiener-Lee-Theorems.
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 26.11.2014/25.05.2018

% Laden der Signale
load inputsig
load outputsig

% Berechnung der Autokorrelationsfunktionen
xin = xcorr(inputsig, 'unbiased');
xout = xcorr(outputsig, 'unbiased');

% Leistungsdichte der Signale mit Hilfe der FFT
% der Autokorrelationssignale berechnen
N = length(xin); M = floor(N/2);
K = 4*1024;  % 4*1024 Werte aus der Mitte herausschneiden
cinmitte = xin(M-K+1:M+K);   
coutmitte = xout(M-K+1:M+K); 
Phixx = fft(cinmitte, 2*K);
Phiyy = fft(coutmitte, 2*K);
 
% Schtzung des Betragsquadrats der 
% bertragungsfunktion nach Wiener-Lee
Hquad = Phiyy./Phixx;

fa = 2048;               % Abtastrate
df = fa/(2*K);           % Frequenzabstand
frq = (0:df:fa/2-df);

% Darstellung des Amplitudengangs
% (nur fr positive Frequenzen)
semilogx(frq, 10*log10(abs(Hquad(1:K))), 'b', 'LineWidth', 2);
grid
xlabel('Frequenz / Hz')
ylabel('|H|/ dB')

