function [frq, CorrFFT] = CorrsigFFT(corrSignal, fa)
%
% Funktion  CorrsigFFT
%
% Aufruf:  [frq, CorrFFT] = CorrsigFFT(corrSignal, fa)
%
% Aufrufbeispiel: [frq, CorrNoiseFFT] = CorrsigFFT(corrNoise, 1000);
%
% Mit Hilfe dieser Funktion wird eine 1-K-FFT des Signals
% corrSignal berechnet.
%
% Dabei wird davon ausgegangen, dass es sich bei corrSignal
% um eine Autokorrelationsfolge handelt, die mehr als 1024
% Punkte enthlt. Da die Autokorrelationsfolgen an ihren Enden 
% jeweils nur auf sehr wenigen Signalwerten beruhen, werden
% 1024 Punkte aus DER MITTE des Autokorrelationssignals
% herausgeschnitten und zur FFT-Berechnung herangezogen.
%
% Das berechnete FFT-Spektrum wird zudem geplottet.
% 
% Eingabeparameter:    corrSignal  Autokorrelationssignal
%                      fa          Abtastrate
%                          
% Ausgabeparameter:    frq         Frequenzvektor (Hz)
%                      CorrFFT     FFT-Spektrum
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 21.11.2014/25.05.2018


% Initialisierungen
M = length(corrSignal);
mitte = floor(M/2);
corrSignalAusschnitt = corrSignal(mitte-512:mitte+512);

N = 1024;               % 1-K-FFTs
df = fa/N;              % Frequenzabstand
frq = (0:df:(N-1)*df);  % Frequenzvektor

% FFT-Spektrum berechnen
CorrFFT = fft(corrSignalAusschnitt,N);

% Betrag des FFT-Spektrums plotten
figure
plot(frq, abs(CorrFFT),'b','LineWidth',3)
grid
xlabel('Frequenz/Hz')
ylabel('|FFT|')
axis([0,fa,0,1.1*max(abs(CorrFFT))])

