% Script RCSimuOrd1.m
%
% Aufruf: RCSimuOrd1
%
% Skript-File zur Simulation 1-ter Ordnung
% eines RC-Tiefpasses mit Zeitkonstante T=1
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 05.11.2014/23.05.2018

% bertragungsfunktion des RC-Tiefpass
% definieren
T = 1;
s = tf('s');
H = 1/(T*s+1);

% Frequenz des sinusfrmigen Eingangssignals in Hz definieren
% (es wird ein 2 Hz-Sinus simuliert)
frq = 2;    % hier ggf. andere Frequenz editieren

% Amplituden- und Phasennderung berechnen
[Amp,phas] = bode(H,2*pi*frq);

% Nullpahse in rad umrechnen
nphas = 2*pi*phas/360;

% Zeitintervall fr die grafische Darstellung festlegen
t = (0:0.001:5);

% Theoretisches Ausgangssignal des RCTP berechnen
sigaus = Amp*sin(2*pi*frq*t+nphas);

% Abtastrate fa festlegen
% fa = 10;  
fa = 25;  % (ggf. Script hier editieren)
Ta = 1/fa;

% Sinusfrmiges Eingangssignal abtasten
tn = (0:Ta:5); N = length(tn);
xn = sin(2*pi*frq*tn);

% Simulation mit Hilfe einer for-Schleife

    % Vorinitialisierung (erster Eintrag y0)
    % (man beachte dass MATLAB ab 1 statt ab
    % 0 indizieren muss)
yn = [Ta/(2*T)*xn(1), zeros(1,N-1)]; 

for n=2:N
    % Berechnung nach Lsung bungsaufgabe
    % Initialisierung der c-Koeffizienten fr 
    % den Index n
    k = (0:1:n);
    c = (Ta/2)*exp(-(n-1-k)*Ta/T);
    yn(n) = (1/T)*((Ta/2)*xn(1)*exp(-n*Ta/T)+(Ta/2)*xn(n) + ...
        2*xn(2:n-1)*(c(1:n-2)'));
end

% Grafische Darstellung der Simulation
% in einem eingeschwungenen Bereich
plot(t,sigaus,'b-','LineWidth',3);
hold
stairs(tn,yn,'k-','LineWidth',3);
% zum Vergleich noch die Darstellung als
% Polygonzug (lineare Verbindung zwischen den Werten)
plot(tn,yn,'g-','LineWidth',3);
grid
axis([4, 5, -1.2*Amp, 1.2*Amp])
xlabel('Zeit/s')
ylabel('Amp')
hold off
