% Script TPFilterLDS.m
%
% Aufruf:  TPFilterLDS
%
% Berechnet das Leistungsdichtespektrum eines im Frequenzbannd
% [-50,50] Hz Tiefpass-gefilterten weien Rauschens.
% 
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 23.11.2014/25.05.2018

% Erzeugung des weien Rauschsignals
rng('shuffle', 'twister')
signal = sqrt(2)*randn(1,10000);

% Konstruktion des Filters mit dem fdatool
% lieferte die Funktion TPFilterBLWN
Hd = TPFilterBLWN;

% Filterung des Signals
fsignal = filter(Hd,signal);

% Berechnung des diskreten Leistungsdichtespektrums
% des Filter-Ausgangssignals
% Berechnung des Autokorrelationssignals
rxx = xcorr(fsignal, 'unbiased');

% Leistungsdichte mit Hilfe der FFT
N = 1024;                  % fr 1-K-FFT
m = length(fsignal);
K = floor(N/2);
rxxmitte = rxx(m-K:m+K-1); % N Werte SYMMETRISCH
                           % herausschneiden
Pxx = fft(rxxmitte);       % FFT berechnen
Pxx = fftshift(Pxx);       % Symmetrisch um 0

fa = 200;
df = fa/N;                 % FFT-Frequenzraster
frq = (-fa/2:df:fa/2-df);  % Frequenzen in Hz

% Grafische Darstellung des ZEITKONTINUIERLICHEN
% Leistungsdichtespektrums! Hierfr muss das DISKRETE
% Leistungsdichtespektrum mit 1/fa skaliert werden!!
plot(frq, (1/fa)*abs(Pxx), 'b', 'LineWidth',3)
grid
xlabel('Frequenz/Hz')
ylabel('|S_{XX}(k)|')
axis([-100,100,0,0.05])