% Script bspImpz.m
%
% Aufruf: 	bspImpz
%
% Beispiel zur Berechnung der Impulsantwort eines
% diskreten LTI-Systems mit Hilfe der Funktion impz
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 08.11.2014/23.05.2018

b=[0.5 -1 -0.5];      % Zhlerkoeffizienten definieren
a=[1 0 0];            % Nennerkoeffizienten definieren

% die ersten 10 Werte der Impulsantwort berechnen
[h,n] = impz(b,a,(0:1:9)); 

% Alternative Berechnung mit impulse und tf-Objekten
z = tf('z',1);
H = ((1/2)*z^2-z-(1/2))/(z^2);

% die ersten 10 Werte der Impulsantwort berechnen
[h2,nk] = impulse(H,(0:1:9)); 

% Ausgabe zu Vergleich
[h,n,h2,nk]
