function [dtimeft] = diedft(signal, f, fabtast)
%
% Aufruf:  [dtimeft] = diedft(signal, f, fabtast)
%
% liefert die DFT (dtimeft) an den Stellen f (Frequenzvektor)
% zum diskreten Signal signal, abgetastet mit fabtast.
% Der Vektor dtimeft enthlt die komplexen DFT-
% Werte.
% Zu Plot-Zwecken kann anschlieend mit dem
% Kommando abs der Vektor der Absolutbetrge
% gebildet und mit plot(f,absolutbetrge)
% geplottet werden (Amplitudenspektrum)
%
% Eingangsparameter:      signal   (diskretes Signal)
%                         f        Vektor von Frequenzen (in Hz), an denen
%                                  die DFT berechnet werden soll
%                         fabtast  Abtastfrequenz (in Hz)
%
% Ausgangsparameter:      dtimeft  Werte der DFT an den Stellen f
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018


% Frequenzen in rad definieren
Omega = 2*pi*f./fabtast;        

% Indexvektor definieren
N = length(signal);

% DFT-Werte vorinitialisieren
dtimeft = zeros(size(signal));

% DFT in Doppelschleife realisieren
for m = 0:1:N-1          % Frequenzen
    for k = 0:1:N-1      % Zeitwerte
                         % beachte: MATLAB-Vektorindizierung 
                         % beginnt bei 1 statt bei 0
        dtimeft(m+1) = dtimeft(m+1)+signal(k+1)*exp(-1i*k*Omega(m+1));
    end
end

