% Script diodkenn.m
%
% Aufruf: diodkenn
%
% Skript-File zur Darstellung einer Diodenkennlinie.
%
% Die Parameter:
%
% Is               Sperrsttigungsstrom
% VD               angelegte Annoden-Kathoden-Spannung
% VT               Temperaturspannung
% ID               Diodenstrom
%
% Die Werte der Parameter Is und VT knnen hier
% editiert werden.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 07.08.2014/22.05.2018


Is = 10^(-15);     % Sperrsttigungsstrom in A
VT = 25;           % Temperaturspannung in mV

% Kennlinie berechnen
VD = (0.5:0.01:0.75);
ID = Is*(exp(VD/(VT/1000))-1);

% Arbeitspunkt berechnen (in mA, daher Faktor 1/1000)
IDa = Is*(exp(0.7/(VT/1000))-1);

% Ergebnis plotten
subplot(121)
plot(VD,1000*ID,'b','LineWidth',3);

% Arbeitspunkt markieren
hold
scatter(0.7, 1000*IDa, 100, 'k', 'filled');

% Linearisierung berechnen und plotten
IL = 10^(-12)*(exp(28)-1)+4*10^(-11)*exp(28)*(VD-0.7);
plot(VD,IL,'k','LineWidth',3);

axis([0.5, 0.75, 0, 12])
xlabel('VD/Volt')
ylabel('ID/mA')
grid

% Ergebnisausschnitt plotten
subplot(122)
plot(VD,1000*ID,'b','LineWidth',3);

% Arbeitspunkt markieren
hold
scatter(0.7, 1000*IDa, 100, 'k', 'filled');

% Linearisierung berechnen und plotten
IL = 10^(-12)*(exp(28)-1)+4*10^(-11)*exp(28)*(VD-0.7);
plot(VD,IL,'k','LineWidth',3);

axis([0.695, 0.705, 1, 2])
xlabel('VD/Volt')
ylabel('ID/mA')
grid

