% Script init_diode.m
%
% Initialisiert fr das Simulink-File
%
%       s_diode.slx
%
% Die Parameter:
%
% stoptime         Simulationsdauer
% fixstep          Schrittweite einer Fixed-Step Simulation
% VT               Temperaturspannung in mV
% Is               Sperrsttigungsstrom in mA
% amp              Amplitude einer sinusfrmigen Anregung
%                  um den Arbeitspunkt herum in mV
% frq              Frequenz (Hz) der sinusfrmigen Anregung
%                  um den Arbeitspunkt herum
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_diode.slx durch Mausclick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.08.2014/22.05.2018

stoptime = 10;     % Simulationsdauer
fixstep = 0.01;    % Schrittweite einer Fixed-Step Simulation
VT = 25;           % Temperaturspannung in mV
Is = 10^(-12);     % Sperrsttigungsstrom in mA
amp = 5;           % Amplitude einer sinusfrmigen Anregung
                   % um den Arbeitspunkt herum in mV
frq = 1;           % Frequenz (Hz) der sinusfrmigen Anregung
                   % um den Arbeitspunkt herum

