% Script init_uebDLTI.m
%
% Initialisiert fr das Simulink-File 
%
%       s_uebDLTI.slx
%
% die Parameter:
%
% stoptime         Simulationsdauer
% fixstep          Schrittweite einer Fixed-Step Simulation
% T                Parameter des Systems mit der Differenzengleichung
%
% frequenz         Frequenz der komplexen harm. Schwingung am Eingang
%
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_uebDLTI.slx
% durch Mausclick vor der Simulation initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.02
% Datum: 15.11.2014/22.05.2018

stoptime = 100;     % Simulationsdauer
fixstep = 1;        % Schrittweite einer Fixed-Step Simulation

T = pi^2/36;        % Systemparameter

fa = 1/fixstep;
frequenz = fa*pi/6; % Frequenz des Eingangssignals

%