% Script init_uebbutterTP
%
% Initialisiert fr das Simulink-File
%
%       s_uebbutterTP.slx
%
% die Parameter:
%
% stoptime         Simulationsdauer
% fa               Abtastrate = Schrittweite einer Fixed-Step Simulation
% a_0,a_1,a_2      Zhlerkoeffizienten des Butterworth-Filters
% b_1, b_2         Nennerkoeffizienten des Butterworth-Filters
%
% frq              Signalfrequenz des harmonischen Eingangssignals
%
% Die Werte der Parameter knnen hier
% editiert werden und werden mit dem Initialisierungsbutton
% im Simulink-File s_uebbutterTP.slx durch Mausclick vor der Simulation
% initialisiert.
%
%%%%%%%%%%%%%%%%%%%%%%%%% Wichtiger Hinweis !%%%%%%%%%%%%%%%%%%%%%%%%% 
%
%  Die Parameter werden ber Variablennamen im Workspace an die
%  Simulink-Blcke bergeben. Die Parameter der Blcke drfen daher nicht
%  verndert werden. Falls dies versehentlich geschehen sollte, so
%  ersetzen Sie das Simulink-System durch die entsprechende Kopie
%  aus der Original-Begleitsoftware!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.01
% Datum: 16.11.2014/22.05.2018

stoptime = 2;      % Simulationsdauer
fa = 1000;         % Abtastrate
fixstep = 1/fa;    % Schrittweite einer Fixed-Step Simulation

frq = pi/6*fa/(2*pi); % 2*pi*frq/fa = pi/6  (3-dB-Grenzfrequenz)

% Zhlerkoeffizienten des Butterworth-Filters
a_0=0.0495; a_1=0.0990; a_2=0.0495;

% Nennerkoeffizienten des Butterworth-Filters
b_1=-1.2796; b_2=0.4776;

