% Script-File lsg_verzsigs.m
%
% Aufruf: lsg_verzsigs
%
% Berechnet die um rho=2 verzgerten Signale aus 
% bungsaufgabe 7 von Kapitel 2 und plottet diese 
% im Intervall [0,4] zusammen mit den ursprnglichen Signalen
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 11.08.2014/22.05.2018 

t = (-1:0.01:4);  % Darstellungsbereich
rho = 2;          % Verzgerung

% Signale aus Aufgabenteil (a)
x1 = t>=0;       % Einheitssprung ab 0
y1 = t>=rho;

% Signale aus Aufgabenteil (b)
x2 = exp(-(t).^2/2).*(t>=0);
y2 = exp(-(t-rho).^2/2).*(t>=2);

% Signale aus Aufgabenteil (c)
x3 = t.*(t<1) + ...
      exp(-(t-1)).*(t>=1);
y3 = (t-rho).*(t>=2 & t<3) + ...
      exp(-(t-rho-1)).*(t>=3);
  
% Signale plotten
subplot(311)
plot(t,x1,'b:',t,y1,'k', 'LineWidth',3);
axis([-1,4,0,1.2])
grid
xlabel('t/s')

subplot(312)
plot(t,x2,'b:',t,y2,'k', 'LineWidth',3);
axis([-1,4,0,1.2])
grid
xlabel('t/s')

subplot(313)
plot(t,x3,'b:',t,y3,'k', 'LineWidth',3);
axis([-1,4,0,1.2])
grid
xlabel('t/s')