function [signal] = myIFFT(DFTdaten)
%
% Aufruf: [signal] = myIFFT(DFTdaten)
%
% Berechnung inversen DFT fr einen Vektor DFTdaten.
% 
% Die Berechnung erfolgt dabei auf der Grundlage der 
% formalen hnlichkeit zwischen der Formel zur Berechnung der DFT
% und der Formel zur Berechnung der inversen DFT mit Hilfe des
% FFT-Algorithmus.
%
% Eingabeparameter:    DFTdaten   Folge von (gedachten) 
%                                 DFT-Spektralwerten
%
% Ausgabeparameter:    signal     Inverse DFT dieser Werte
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 15.11.2014/23.05.2018

% DFT-Daten konjugieren
N = length(DFTdaten);
y = conj(DFTdaten);

% FFT berechnen
sg = fft(y,N);

% Signalwerte durch Normieren und Konjugieren
% bestimmen
signal = conj(sg)/N;
