function [iantw, spantw] = ueb1rec_formel(N)
%
% Aufruf: [iantw, spantw] = ueb1rec_formel(N)
%
% Aufrufbeispiel: [iantw, spantw] = ueb1rec_formel(10);
%
% Berechnet Impulsantwort iantw und Sprungantwort
% spantw des digitalen LTI-Systems, welches 
% durch die Rekursionsformel 
%
%       y_n = x_{n-1} -2*x_{n-2} +(5/8)*x_{n-1}-(1/3)*y_{n-2}, 
%       y_{-1}=y_{-2}=0
%
% gegeben ist und stellt die Signale grafisch dar.
%
% Eingangsparameter:     N       Index des letzten zu berechnenden
%                                Wertes
%
% Ausgangsparameter:     iantw   Impulsantwort h_0,...h_N 
%                        spantw  Sprungantwort y_0,...y_N 
% 
% Die Anfangswerte y_{-1}, y_{-2} werden dabei als
% 0 angenommen, d.h. das System ist zu Beginn "in Ruhe".
% Das Eingangssignal x_{n} wird als KAUSAL angenommen, d.h.
% x_{-1}, x_{-2} sind 0.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 07.11.2014/23.05.2018 

                            % Vorinitialisierungen
iantw = [0, 0, zeros(1,N)]; 
spantw = [0, 0, zeros(1,N)]; 
                            % Definition des diskreten Impulses
                            % (beginnt mit \delta_0(-2) da in
                            % der Rekursion darauf zurck gegriffen wird)
deltan = [0, 0, 1, zeros(1,N)];

                            % Definition des diskreten Sprunges
                            % (beginnt mit \sigma(-2) da in
                            % der Rekursion darauf zurck gegriffen wird)
sigman = [0, 0, ones(1,N+1)];

% die Rekursionsformel (der Index ist aus programmiertechnischen 
% Grnden um 2 Takte verschoben)
for k=1:N
    iantw(k+2) = deltan(k+1) - 2*deltan(k) ...
                 + (5/8)*iantw(k+1) - (1/3)*iantw(k);
    spantw(k+2) = sigman(k+1) - 2*sigman(k) ...
                 + (5/8)*spantw(k+1) - (1/3)*spantw(k);
end

% Elimination der knstlich eingefgten Nullen
% (entspricht Umindizierung)
iantw(1:2) = [];
spantw(1:2) = [];

% Ergebnis grafisch darstellen
indx = (0:1:N-1);
subplot(211)
stem(indx, iantw, 'k', 'LineWidth', 3);
xlabel('Index/n')
ylabel('h_n')
grid
subplot(212)
stem(indx, spantw, 'b', 'LineWidth', 3);
xlabel('Index/n')
ylabel('y^{(\sigma)}_n')
grid




