% Script ueb3FR.m
%
% Aufruf: ueb3FR
%
% Berechnungen zu bung 60 zur Bestimmung
% der Fourier-Reihenentwicklung einer periodischen Funktion
% mit der Symbolic Math Toolbox
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 30.10.2014/22.05.2018

% Definition der Funktion f(t)
syms t k
assume(k, 'integer')
f = sin(2*pi*t)^2

% Berechnung des a0-Koeffizienten 
% (hier w0 = 4*pi = 2*2*pi = 2*pi/T also T=1/2 !!)
T =1/2;
a0 = (2/T)*int(f,0,T)

% Berechnung des Koeffizienten a1
cosk1 = cos(4*pi*t);
a1 = (2/T)*int(f*cosk1,0,T)

% Berechnung der ak-Koeffizienten fr k>=1
cosk = cos(k*4*pi*t);
ak = (2/T)*int(f*cosk,0,T)

% Berechnung der bk-Koeffizienten fr k>=1
sink = sin(k*4*pi*t);
bk = (2/T)*int(f*sink,0,T)
bk = simplify(bk)
