% Script uebAbtastTh.m
%
% Aufruf: uebAbtastTh
%
% Berechnungen zur Bestimmung des Spektrums des Produktsignals
% aus bung 68. 
% Die Signale haben ein rechteckfrmiges und ein 
% dreieckfrmiges reelles Spektrum. 
% Das Spektrum des Produktsignals ergibt sich aus 
% deren Faltung nach dem Multplikationssatz. Die Berechnung dient
% der Ermittlung der Bandbreite mit dem Ziel, die richtige
% Abtastfrequenz gem Abtasttheorem fr das Produktsignal 
% festzulegen. 
% Die folgenden Berechnungen stellen das exakte Ergebnis
% und eine numerische Approximation mit Hilfe der Faltungsfunktion
% conv gegenber.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 2.2
% Datum: 31.10.2014/23.05.2018

% Theoretisches Spektrum des Produktsignals
deltaom = 0.01;
omega = (-20:deltaom:20);
W1 = (omega.^2+30*omega+225).*(omega>=-15 & omega<-10);
W2 = (-omega.^2-10*omega+25).*(omega>=-10 & omega<-5);
W3 = 50*(omega>=-5 & omega<5);
W4 = (-omega.^2+10*omega+25).*(omega>=5 & omega<10);
W5 = (omega.^2-30*omega+225).*(omega>=10 & omega<15);
W = (W1+W2+W3+W4+W5)/(20*pi);

% Numerische Faltung mit conv
om = (-15:deltaom:15);
X = double((om>=-10 & om<=10));
om = (-5:deltaom:5);
Y = (1/5)*((om+5).*(om>=-5 & om<0)+(5-om).*(om>=0 & om<=5));
Wnum = (1/(2*pi))*conv(X,Y)*deltaom;

% Grafische Darstellung
plot(omega, W, 'k-', omega, Wnum, 'k--','LineWidth',3)
grid
xlabel('omega/rad/s')
ylabel('W(j\omega)')

% Plot des Abtastspektrums fr omega_a = 50 rad/s
figure
omega_a = 50;
mega = (-200:deltaom:200);
kom = 3*omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wa3 = (W1+W2+W3+W4+W5)/(20*pi);

kom = 2*omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wa2 = (W1+W2+W3+W4+W5)/(20*pi);

kom = omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wa1 = (W1+W2+W3+W4+W5)/(20*pi);

kom = 0;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wa0 = (W1+W2+W3+W4+W5)/(20*pi);

kom = -omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wam1 = (W1+W2+W3+W4+W5)/(20*pi);

kom = -2*omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wam2 = (W1+W2+W3+W4+W5)/(20*pi);

kom = -3*omega_a;
W1 = ((mega+kom).^2+30*(mega+kom)+225).*((mega+kom)>=-15 & (mega+kom)<-10);
W2 = (-(mega+kom).^2-10*(mega+kom)+25).*((mega+kom)>=-10 & (mega+kom)<-5);
W3 = 50*((mega+kom)>=-5 & (mega+kom)<5);
W4 = (-(mega+kom).^2+10*(mega+kom)+25).*((mega+kom)>=5 & (mega+kom)<10);
W5 = ((mega+kom).^2-30*(mega+kom)+225).*((mega+kom)>=10 & (mega+kom)<15);
Wam3 = (W1+W2+W3+W4+W5)/(20*pi);

Wa = (50/(2*pi))*(Wa3+Wa2+Wa1+Wa0+Wam1+Wam2+Wam3);

% Grafische Darstellung
plot(mega, Wa, 'b-','LineWidth',3)
grid
xlabel('omega/rad/s')
ylabel('W_a(j\omega)')

