% Script uebBode2.m
%
% Aufruf: uebBode2
%
% Berechnungen zu bung 51 zur Bestimmung
% der Systemreaktion eines RCTP auf Schwingungen
% mit Hilfe der Funktion bode
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 27.10.2014/22.05.2018

% Definition der Zeitkonstanten
T = 8.8073e-005;

% Definition der bertragungsfunktion
s = tf('s');
H = 1/(1+T*s)

% Bestimmung der Frequenz in rad/s
omega = 2*pi*1000;

% Aufruf von bode
[a,ph]=bode(H,omega)

% Umrechnung der Amplitudendmpfung in dB
adB = 20*log10(a)

% Umrechnung der Phase in rad
phr = 2*pi*ph/360

% Berechnung der Zeitverzgerung
t0 = -0.5054/(2*pi*1000)

% Plot des Boxde-Diagramms
omega = (0:1:2*pi*100000);
[a,ph]=bode(H,omega);

% Vektoren aus den arrays erzeugen
Ampl = a(:); phase = ph(:);

% Bode-Diagramm plotten
frq = omega/2/pi;    % Frequenzen in Hz

subplot(211)
% Amplitudengang
semilogx(frq, 20*log10(Ampl), 'b', 'Linewidth', 3)
grid
xlabel('Frequenz/Hz')
ylabel('|H(j\omega)|/dB')

% Phasengang
subplot(212)
semilogx(frq, phase, 'b', 'Linewidth', 3)
grid
xlabel('Frequenz/Hz')
ylabel('arg(H(j\omega))/rad')