% Script uebBode3.m
%
% Aufruf: uebBode3
%
% Berechnungen zu bung 53 zur Bestimmung
% des bertragungsverhaltens eines Allpasses
% mit Hilfe der Funktion bode
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 28.10.2014/22.05.2018

% Definition der bertragungsfunktion im Bildbereich
s = tf('s');
H = (1-s)/(1+s)

% Berechnung des Bode-Diagramms
omega=(0:0.01:pi);
[a,ph]=bode(H,omega);

% Vektoren aus den arrays erzeugen
Ampl = a(:); phase = ph(:);

% Anpassung der Phase in diesem Beispiel, da
% bode sonst in der Phase einen offset von 360
% Grad hat (bug von bode)
phase = phase-360;

% Bode-Diagramm plotten
frq = omega/2/pi;    % Frequenzen in Hz

figure
subplot(211)
% Amplitudengang
semilogx(frq, 20*log10(Ampl), 'b', 'Linewidth', 3)
grid
axis([frq(2),frq(end),-20,10])
xlabel('Frequenz/Hz')
ylabel('|H(j\omega)|/dB')
title('Amplitudengang mit bode')

% Phasengang
subplot(212)
semilogx(frq, phase, 'b', 'Linewidth', 3)
grid
axis([frq(2),frq(end),-200,100])
xlabel('Frequenz/Hz')
ylabel('arg(H(j\omega))/grad')
title('Phasengang mit bode')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% berprfung des Erebnisses der analytischen
% Berechnung
omega=(0:0.01:pi);
phs=atan(-2*omega./(1-omega.^2));

% Phase in Grad umrechnen
phsG = phs*360/(2*pi);
% Phasengang darstellen
frq = omega/2/pi;    % Frequenzen in Hz
figure
semilogx(frq, phsG, 'b', 'Linewidth', 3)
grid
axis([frq(2),frq(end),-200,100])
xlabel('Frequenz/Hz')
ylabel('arg(H(j\omega))/grad')
title('Phasengang analytisch')


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Korrigierter Phasengang

omega1=(0:0.01:1);
phs1=atan(-2*omega1./(1-omega1.^2));

omega2=(1.01:0.01:pi);
phs2=atan(-2*omega2./(1-omega2.^2))-pi;

omega =[omega1,omega2];
phs =[phs1,phs2];

% Phase in Grad umrechnen
phsG = phs*360/(2*pi);
% Phasengang darstellen
figure
frq = omega/2/pi;    % Frequenzen in Hz
semilogx(frq, phsG, 'b', 'Linewidth', 3)
grid
axis([frq(2),frq(end),-200,100])
xlabel('Frequenz/Hz')
ylabel('arg(H(j\omega))/grad')
title('Bereinigter Phasengang')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Analytische Berechnung der Impulsantwort

syms s
a = 1;

% Definition der bertragungsfunktion mit
% der Symbolic Math Toolbox
H = (a-s)/(a+s)

% Berechnung der Impulsantwort
h = ilaplace(H)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Darstellung der Systemantwort auf sigma(t)*exp(-b*t) 
% fr Parameter a=1, b=2
a = 1;
b = 2;
t = (0:0.001:3);
y = (2*a/(b-a))*(exp(-a*t)-exp(-b*t))-exp(-b*t);
figure
plot(t,y,'b','LineWidth',3)
grid
xlabel('Zeit/s')
ylabel('Amplitude')
title('Antwort auf sigma(t)*exp(-b*t)')