% Script uebDAUSpect.m
%
% Aufruf:     uebDAUSpect
%
% Berechnungen zur Bestimmung
% des Spektrums eines D/A-Wandler-Ausgangssignals
% (Abtast-Halte-Spektrum) aus bung 71.
%
% Autor: Prof. Dr. Ottmar Beucher
%        HS Karlsruhe
% Version: 1.2
% Datum: 01.11.2014/23.05.2018

% Signalfrequenz und Abtastfrequenz 
omega0 = 2*pi;
omegaa = 2*pi*4;
T = 1/4;             % Abtastintervall

% eine Reihe von Harmonischenfrequenzen
n = (-3:1:3);
frq1 = omega0+n*omegaa;
frq2 = -omega0+n*omegaa;

% Koeffizienten der Dirac-Impulse an diesen Stellen
coeff1 = pi*abs(sinc(omega0*T/(2*pi)+n));
coeff2 = pi*abs(sinc(-omega0*T/(2*pi)+n));

% Ergebnis nach Frequenzen aufsteigend sortieren
frq = [frq1,frq2];
coeff = [coeff1,coeff2];
[frq,indx] = sort(frq);
coeff = coeff(indx);

% Ergebnis grafisch darstellen 
stem(frq,coeff,'b^','Linewidth', 3)
xlabel('Frequenz/rad/s')
ylabel('Gewichte Dirac-Impulse')
grid
